#include <ctype.h>       /* eeprom-4-msdos_LPT1-IBM-Computer20MHz */ 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

#define out_1    0x378         /* ausgabeport       */
#define cnt_1    0x37A       /* controllregister  */
#define in_1     0x379        /* statusregister  */
#define max_1    256              /* pufferraum */
#define dat_1 "eeprom2.bin"        /* ein-, ausgabefile binaer */
#define dat_2 "eeprom2.hex"      /* ein-,ausgabefile ascii */
   
void eepwrite();            /* eeprom beschreiben */
void eepread();            /* eeprom lesen */
int testval();               /* puffer laenge betimmen */
void delay();                   /* warteschleife */
int captim();                   /* zeit ermitteln */
void bufstr();                  /* puffer ausgabe */
unsigned long int testlen();     /* datei laenge bestimmen */
void fillstr();               /* puffer  neu beschreiben */
void dawrite();             /* datei anlegen */
void daread();                  /* datei lesen */
void zefill();                  /* zeichen ablegen */
void answ();                   /* warnungen ausgeben */
void help();                      /* information anzeigen */
void main(int argc, char **argv)      /* funktion waehlen */
   {        
   int prom,fkt,tim,val;
   char data[max_1];                /* puffer bereitstellen */
   unsigned long int adr;     /*  ini startadr */
   unsigned long int byte;    /*  ini bytelen */
       
   prom=atol(argv[1]);     /* promtype setzen */
   switch(prom)
       {
       case 0: help();
               exit(0);
       case 1: adr=0;          /* 28c16 */
               byte=2048;
               tim=5;
               break;
       case 2: adr=0;
               byte=8192;     /* 28c64 */  
               tim=5;
               break;
       case 3: adr=0;
               byte=16384;    /* eprom 27128 */
               tim=5;
               break;
       case 4: adr=0;          /* 28c256 */
               byte=32768; 
               tim=5;
               break;
       case 5: adr=0;          /* 28c512 */
               byte=65536; 
               tim=5;
               prom=4;
               break;
       case 6: adr=0;          /* 28c1024 */
               byte=131072; 
               tim=2;
               prom=4;
               break;
      default: help();
               exit(0);
       }

   
   switch(argc)
       {
         case 0:
         case 1: help();
                 exit(0);
         case 2: fkt=0;
                 tim=captim(tim);
                 break;
         case 3: fkt=atol(argv[2]);        /* funktion setzen */
                 tim=captim(tim);
                 break;
         case 4: fkt=atol(argv[2]);        /* funktion setzen */
                 adr=atol(argv[3]);       /*  startadr laden */
                 byte=byte-adr;
                 tim=captim(tim);
                 break;
         case 5: fkt=atol(argv[2]);        /* funktion setzen */
                 adr=atol(argv[3]);                   /*  startadr laden */                 
                 if( adr <= byte )
                   if( (adr+atol(argv[4])) < byte )
                       byte=atol(argv[4]);              /*  bytelen neu  */
                       else
                       byte=byte-adr;                  /* bytelen restwert */
                    else
                     { 
                      answ(2);
                      exit(0);
                      }
                 tim=captim(tim);
                 break;
         case 6: fkt=atol(argv[2]);        /* funktion setzen */
                 adr=atol(argv[3]);                   /*  startadr laden */
                 if( adr <= byte )
                   if( (adr+atol(argv[4])) < byte )
                       byte=atol(argv[4]);              /*  bytlen neu  */
                       else
                       byte=byte-adr;                  /* bytelen restwert */                
                    else
                     { 
                      answ(2);
                      exit(0);
                      }
                  val = strlen(argv[5]);  /* wert mu nach var um dann ... */
                  if( val<3 )
                     tim=captim(atol(argv[5]));       /* zeit  setzen */
                   else
                      {
                       tim=captim(tim);
                       answ(4);
                      }
                 break;
        default: help();
                 exit(0);
       }
  
   switch(fkt)
       {
       case 0:  
       case 1: dawrite( data,dat_2,adr,byte,fkt,tim,prom ) ; 
               break;  
       case 2: dawrite( data,dat_1,adr,byte,fkt,tim,prom ) ; 
               break; 
       case 3: daread( data,dat_2,adr,byte,fkt,tim,prom );
               break;
       case 4: daread( data,dat_1,adr,byte,fkt,tim,prom );
               break;
       case 5: zefill( data,0x00,adr,byte,tim,prom );
               break;
       case 6: zefill( data,0xFF,adr,byte,tim,prom );
               break;
      default: help();
               exit(0);
        }           
   }                      
       
void eepwrite(char *z,unsigned long int a, int b, int v, int w, int t,int p )  
 {    /*      data,      start,           bytelen, out,   status, zeit, type */

   int l,h,j,k,m,s;
   char r;
   unsigned long int d=a;
       
    for(; a<(d+b); a++)
      {         
        h=a/256;
        l=a-(h*256);

     switch(p)
        {
        case 0:
        case 1: h &= 0x07;
                outp(w,0x0L);        /* cl high  */                      
                outp(v,z[a-d]);        /*  */
                delay( t );                  
                outp(w,0x02);        /* cl low  */
                delay( t );              
                outp(w,0x0L);         /* cl high  */       
                outp(v,l);                  
                delay( t );               
                outp(w,0x02);         /* cl low  */
                delay( t );              
                outp(w,0x0L);         /* cl high  */       
                outp(v,h);
                delay( t );         /* untere sowie obere 4 Byte lesen */
                outp(w,0x02);
                delay( t );
                outp(w,0x06);         /* 1OEn low */
                delay( t*5 );       
                outp(w,0x02);
                delay( t );
                break;                           
        case 2: h &= 0xBF;
                outp(w,0x0L);             /* cl high */
                outp(v,z[a-d]);           /* daten bereitstellen */  
                delay( t );              
                outp(w,0x02);             /* cl low */ 
                delay( t );                  
                outp(w,0x0L);             /* cl high */       
                outp(v,l);                /* low adresse bereitstellen */    
                delay( t );                      
                outp(w,0x02);             /* cl low */
                delay( t );                 
                outp(w,0x0L);             /* cl high */       
                outp(v,h);                /* high adresse bereitstellen */        
                delay( t );                      
                outp(w,0x02);             /* cl low  */
                delay( t );
                outp(w,0x06);             /* we high, daten einschreiben */
                delay( t*5 );             
                outp(w,0x02);             /* we und cl low */
                delay( t );            
                break;
        case 4: j = 0x20;
                j ^= h;                /* bit der adresse A13 inv. */ 
                j &= 0xBF;
                if(!(h&0x40))
                   { k=0x01,m=0x03,s=0x07; }
                   else
                   { k=0x0L,m=0x02,s=0x06; }
                outp(w,k);             /* cl high */
                outp(v,z[a-d]);           /* daten bereitstellen */  
                delay( t );              
                outp(w,m);             /* cl low */ 
                delay( t );                  
                outp(w,k);             /* cl high */       
                outp(v,l);                /* low adresse bereitstellen */    
                delay( t );                      
                outp(w,m);             /* cl low */
                delay( t );                 
                outp(w,k);             /* cl high */       
                outp(v,j);                /* high adresse bereitstellen */        
                delay( t );                      
                outp(w,m);             /* cl low  */
                delay( t );
                outp(w,s);             /* we high, daten einschreiben */
                delay( t*5 );             
                outp(w,m);             /* we und cl low */
                delay( t );            
                break;
       default: break;
        }       
    }
}
       
void eepread(char *z,unsigned long int a, int b, int u, int v, int w,int t,int p )  
 {    /*      data       start            byte   in     out    status time type */

   int x,y,l,h,j,k,m,s;
   unsigned long int d=a;
       
    for(; a<(d+b); a++)
      {

     /* adresse bereitstellen       */
   
        h=a/256;
        l=a-(h*256);

  switch(p) 
        { 
          case 0:    
          case 1: h |= 0x08 ;
                  outp(w,0x0L);        /* cl high  */                      
                  outp(v,0x00);        /* potenzial fr Z-imp. low */
                  delay( t );                  
                  outp(w,0x02);        /* cl low  */
                  delay( t );              
                  outp(w,0x0L);         /* cl high  */       
                  outp(v,l);                  
                  delay( t );               
                  outp(w,0x02);         /* cl low  */
                  delay( t );              
                  outp(w,0x0L);         /* cl high  */       
                  outp(v,h);
                  delay( t );         /* untere sowie obere 4 Byte lesen */
                  outp(w,0x02);         /* 1OEn low */
                  delay( t );       
                  x = inp(u) & 0x78  ;  /*  D0-D3 lesen */     
                  outp(w,0x0E);         /* 2OEn low */
                  delay( t );                           
                  y = inp(u) & 0x78  ;  /* D4-D7 lesen */                     
                  outp(w,0x02);         /* 1-2OEn high  cl low   */
                  delay( t );            
                  break;
          case 2: h |= 0x40;
                  outp(w,0x0L);        /* cl high  */                      
                  outp(v,0x00);        /* potenzial fr Z-imp. low */
                  delay( t );                  
                  outp(w,0x02);        /* cl low  */
                  delay( t );              
                  outp(w,0x0L);        /* cl high  */               
                  outp(v,l);
                  delay( t );               
                  outp(w,0x02);        /* cl low  */
                  delay( t );
                  outp(w,0x0L);        /* cl high  */       
                  outp(v,h);
                  delay( t );          /* untere sowie obere 4 Byte lesen */
                  outp(w,0x02);        /* 1OEn cl low */
                  delay( t );           
                  x = inp(u) & 0x78;   /*  D0-D3 lesen */     
                  outp(w,0x0E);        /* 2OEn low */
                  delay( t );                           
                  y = inp(u) & 0x78;   /* D4-D7 lesen */                     
                  outp(w,0x02);        /* 2OEn high  cl low    */
                  delay( t );       
                  break;
          case 3: j = 0x20;
                  j ^= h;                /* bit A13 der adresse inv. */ 
                  j |= 0x40;
                  outp(w,0x0L);        /* cl high  */                      
                  outp(v,0x00);        /* potenzial fr Z-imp. low */
                  delay( t );                  
                  outp(w,0x02);        /* cl low  */
                  delay( t );              
                  outp(w,0x0L);        /* cl high  */               
                  outp(v,l);
                  delay( t );               
                  outp(w,0x02);        /* cl low  */
                  delay( t );
                  outp(w,0x0L);        /* cl high  */       
                  outp(v,j);
                  delay( t );          /* untere sowie obere 4 Byte lesen */
                  outp(w,0x02);        /* 1OEn cl low */
                  delay( t );           
                  x = inp(u) & 0x78;   /*  D0-D3 lesen */     
                  outp(w,0x0E);        /* 2OEn low */
                  delay( t );                           
                  y = inp(u) & 0x78;   /* D4-D7 lesen */                     
                  outp(w,0x02);        /* 2OEn high  cl low    */
                  delay( t );       
                  break;
          case 4: j = 0x20;
                  j ^= h;                /* bit A13 der adresse inv. */            
                  j |= 0x40;
                  if(!(h&0x40))
                      { k=0x01,m=0x03,s=0x0F; }
                      else
                      { k=0x0L,m=0x02,s=0x0E; }
                  outp(w,k);        /* cl high  */                      
                  outp(v,0x00);        /* potenzial fr Z-imp. low */
                  delay( t );                  
                  outp(w,m);        /* cl low  */
                  delay( t );              
                  outp(w,k);        /* cl high  */               
                  outp(v,l);
                  delay( t );               
                  outp(w,m);        /* cl low  */
                  delay( t );
                  outp(w,k);        /* cl high  */       
                  outp(v,j);
                  delay( t );          /* untere sowie obere 4 Byte lesen */
                  outp(w,m);        /* 1OEn cl low */
                  delay( t );           
                  x = inp(u) & 0x78;   /*  D0-D3 lesen */     
                  outp(w,s);        /* 2OEn low */
                  delay( t );                           
                  y = inp(u) & 0x78;   /* D4-D7 lesen */                     
                  outp(w,m);        /* 2OEn high  cl low    */
                  delay( t );       
                  break;
         default: break;
        }   
         /*  spiegelbildliches Byte erstellen   */

       z[a-d] |= ((x/8 + y*2 ) & 0x88) /0x08   ;
       z[a-d] |= ((x/8 + y*2 ) & 0x44) /0x02   ;       
       z[a-d] |= ((x/8 + y*2 ) & 0x22) *0x02   ;
       z[a-d] |= ((x/8 + y*2 ) & 0x11) *0x08 ;
    }  
}

int testval( unsigned long int a,int b,int c )
{  /*         bytelen           blk    puffer */

  if( !(a %c) ) 
    return(c) ;
    else
      if( (a-(b*c)) >= c )
       return(c) ;
       else
        return(a-(b*c)) ; /* restwert */
}

void delay( int b )
{
    int z[100];
    int a,c,d,e,i;
     
    for( a=0; a<b; ++a)
	for( c=0, d=3; d<100; d+=2 )
	    if( !z[d] )
	    {
		e=2*d;
		for( i=3*d; i<100; i+= e)
		    z[i] = -1;
		++c;
	    }
}

int captim( int a )
{
     int b,c,d,j;              /* time*100  in usec */

               for(b=0,c=19; c!=0x00 ; c--)
               { outp(cnt_1,02) ;
                 d=200 ; 
                 do
                  { if(!d)
                    {
                      answ(5);
                      exit(0);    /*  zeitdauer zu lange bei c=0R  */
                     }
                     else d-- ;
                  } while( (inp(in_1) & 0x80) != 0x00 );      
                 d=1000 ;
                 do    
                  { outp(cnt_1,03);
                    if(!(d-b))
                    {
                      answ(5);
                      exit(0);      /* zeitdauer zu lange */
                    }
                     else b++;
                  } while( (inp(in_1) & 0x80) == 0x00 );
               }

       if( (b>6000) || (b<-0) )
        {
         answ(3);
         exit(0);
        }
          else
            ;
        if( (b*a/150) <= 1 )
         {
          answ(6);
          exit(0); 
          }
          else
            ; 
       return( b*a/150 ) ;
}

void bufstr(char *z, int b)              
{ 
   int a= 0 ;  
	do
	  {                                        
            printf(" %.2X",z[a]&0xFF) ;                
            a++ ;
              if(!( a % 16 ))
                  printf("\n") ;           
                  else
                   ;
          } while( a!=b );
 }

unsigned long int testlen(char *s)
{		
 int y, *z ;
 unsigned long int x ;
        y =  open( s, O_BINARY | O_RDONLY );
	x = filelength( y );
	close( y ) ;
  return( x );
}

void fillstr(char *z,int n, int a, int b,int c )              
{
	do
		{
			z[a]= n ;
			a++;
		} while( a!=b );
                  if(!c)
                  ;  else 
                    z[a]= 0x00;   /* zeichenkette ende */
                    
 }

void dawrite(char *z,char *n,unsigned long int c,unsigned long int d, int f,int t,int p)
 { /*         puffer, datei  , startadr          , bytelen   ,    funktion, zeit, type*/

        int a,b,e,k;            /* b= laufende blockzahl */       
        FILE *h;

            if(f==1)
              h=fopen(n,"w");
              else
               if(f==2)
                 h=fopen(n,"wb");       
                 else
                   ;

              if( !( d % max_1))  
                 b=1;  
                else    
                 b=0;   
                                           

            if( (!h) || (!f) )
             { /* wird audgefhrt bei h=0 f=0 */ 
                
                /* die datei nicht geoeffnet */
       
               for(; b<=( d/(testval( d,b,max_1))); b++ )
                 {                   
                 e=testval( d,b,max_1 );
                 fillstr( z,0x00,0,e,0 ); 
                 eepread( z,c,e,in_1,out_1,cnt_1,t,p ) ; 
                 bufstr( z, e );       
                 c=c+e;
                 };               
             }
            else                                         
             for(; b<=( d/(testval( d,b,max_1))); b++)
             {                      
               e=testval( d,b,max_1);
               fillstr( z,0x00,0,e,0);
               eepread( z,c,e,in_1,out_1,cnt_1,t,p ) ;   
               c=c+e;               
               a=0;
                do
                {
                  if( f==2 )
                       {  
                        fprintf(h,"%.2c",z[a]);  
                        a++;
                       }
                      else 
                       {
                        fprintf(h," %.2X",z[a]&0xFF); 
                         a++;
                         if(!( a % 16 ))
                            fputs("\n",h);
                          else
                           ;
                       }                      
                } while( a != e );
             }  
        if(f)
        fclose(h);
        else
          ;
 }

void daread(char *z,char *n,unsigned long int c,unsigned long int d,int f,int t,int p)
 { /*         puffer, datei  , startadr          , bytelen   ,    funktion , zeit, type */
 
        int a,b,e,y,i;            /* b= laufende blockzahl */
        char x;                 
        FILE *h;

           h=fopen(n,"rb");       
              
           if( !( d % max_1))
                b=1;
               else
                b=0;
                                                
            if(!h)  
             { /* wird ausgefhrt bei h=0 */ 
                  
               /* Die Datei konnte nicht geoeffnet werden */
               answ(1);
               help();
             }
            else                                         
             { 
             for(; b<=( d/(testval( d,b,max_1))); b++)
               {                      
               e=testval( d,b,max_1);
               fillstr( z,0x00,0,e,0);                  
               a=0,i=0; 
               do
                 {
               if( f==4 )
                   {      
                        fread(&(z[a]), 1, 1,h );  
                        a++;
                   }  
                   else 
                   {   
                       fread(&x, 1, 1,h) ;                                                                    
                                                  
                      /* einlesen ascii-char und nach int-werte wandeln */                         
                                                                                
                         if((x>='0' && x<='9') || (x>='A' && x<='F'))          
                         {               
                          if( !(i%2) )
                            { 
                             y=0x00;
                               if(x>='A')
                                  x=x-7;
                                  else
                                  ;
                             y |= (x-'0')*16 ; 
                            } 
                            else
                            {
                              if(x>='A')
                                 x=x-7;
                                  else
                                  ;
                             y |= (x-'0') ;
                             z[a]=y;       
                            /* printf(" %.2X",z[a]&0xFF); */ 
                            a++;      
                           }
                       i++ ;
                       }
                       else
                        ;
                   }
                 } while( (a!=e) && !(feof(h)) );       
                eepwrite( z,c,e,out_1,cnt_1,t,p);    
                c=c+e ;
               }    
              if(f)
                 fclose(h);
                 else
                 ;
             }
 }

void zefill(char *z, int n, unsigned long int c,unsigned long int d, int t,int p)
 { /*         puffer, zeichen  , startadr          , bytelen   , zeit, type */
 
        int b,e;            /* b= laufende blockzahl */
              
           if( !( d % max_1))
                b=1;
               else
                b=0;
                                               
             for(; b<=( d/(testval( d,b,max_1))); b++)
               {                      
               e=testval( d,b,max_1);
               fillstr( z,n,0,e,0);                  
               eepwrite( z,c,e,out_1,cnt_1,t,p);    
               c=c+e ;
               }                
 }

void answ(int val)
 {
   switch(val)
        {
          case 0:
                  break;          
          case 1: printf("FILE NOT FOUND! \n");
                  break;
          case 2: printf("ADR TO BIG FOR MEMORY! \n");
                  break;
          case 3: printf("CONTER OVERFLOW! \n");
                  break;
          case 4: printf("DEFAULT TIME SET! \n");
                  break;
          case 5: printf("EEPROM NOT READY! \n");
                  break;
          case 6: printf("TIME TO SHORT! \n");
                  break;
          default:printf("FATAL ERROR! \n");
                  break;
        }

 }

void help()
 { 
  printf("   Directed,created and written by Moosbauer Jun99Vers2 "); 
  printf("\n   C:>EEPROM2  Type Aktion Adr.(Dez.) Byte(Dez.) Time(*100mikrosec)") ;
  printf("\n                                                            ");
  printf("\n                  |      |                                 ");  
  printf("\n                  |       \\________________________         ");  
  printf("\n                  |         0 = EEProm2 -> KONSOLE           ");  
  printf("\n                  |         1 = EEProm2 -> EEPROM2.HEX       ");  
  printf("\n                  |         2 = EEProm2 -> EEPROM2.BIN       ");  
  printf("\n                  |         3 = EEPROM2.HEX -> EEProm2       ");  
  printf("\n                  |         4 = EEPROM2.BIN -> EEProm2        ");  
  printf("\n                  |         5 = INTEGER  00h -> EEProm2       ");  
  printf("\n                  |         6 = INTEGER  FFh -> EEProm2       ");  
  printf("\n                  |                                           ");  
  printf("\n                   \\_______________________________         ");
  printf("\n                     0 = Help     3 = 27c128 (read only)    ");
  printf("\n                     1 = 28c16    4 = 28c256               ");
  printf("\n                     2 = 28c64    5 = 28c512             ");                  
  printf("\n                                  6 = 28c010D (28F001 read only)");
  }
